/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;

public class TransferFullSlotMessage {
    private final int slotId;

    public TransferFullSlotMessage(int slotId) {
        this.slotId = slotId;
    }

    public static void encode(TransferFullSlotMessage msg, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(msg.slotId);
    }

    public static TransferFullSlotMessage decode(PacketBuffer packetBuffer) {
        return new TransferFullSlotMessage(packetBuffer.readInt());
    }

    static void onMessage(TransferFullSlotMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> TransferFullSlotMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayerEntity player, TransferFullSlotMessage msg) {
        ItemStack transferResult;
        if (player == null || !(player.field_71070_bA instanceof BackpackContainer)) {
            return;
        }
        BackpackContainer backpackContainer = (BackpackContainer)player.field_71070_bA;
        Slot slot = backpackContainer.func_75139_a(msg.slotId);
        while (!(transferResult = backpackContainer.func_82846_b((PlayerEntity)player, msg.slotId)).func_190926_b() && ItemStack.func_179545_c((ItemStack)slot.func_75211_c(), (ItemStack)transferResult)) {
        }
    }
}

